Compiler.Control.Print.signatures := 0;
Compiler.Control.Print.printOpens := false;
SMLofNJ.Internals.GC.messages false;
CM.autoloading (SOME true);
CM.autoload' "/home/cwg/sml/rslml/rslml.cm";

structure RT_Int = RT_Int;

structure RT_s_1 = RT_Set(structure Elem = RT_Int);

structure RT_m_2 = RT_Map(structure DomainElem = RT_Int structure RangeElem = RT_s_1);

structure RT_Bool = RT_Bool;

structure RT_l_3 = RT_List(structure Elem = RT_Int);

structure RT_x_4 =
    struct
        type t = RT_Int.t * RT_Int.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_Int.equ(#2 x, #2 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_Int.toString(#2 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^
                              ")";
    end;
    
structure RT_s_5 = RT_Set(structure Elem = RT_x_4);

structure RT_x_6 =
    struct
        type t = RT_Int.t * RT_Int.t * RT_m_2.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_Int.equ(#2 x, #2 y) andalso 
                             RT_m_2.equ(#3 x, #3 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_Int.toString(#2 x )) ^ "," ^
                             (RT_m_2.toString(#3 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_m_2.typeToString ()) ^
                              ")";
    end;
    
structure RT_Unit = RT_Unit;

structure RT_x_7 =
    struct
        type t = RT_l_3.t * RT_l_3.t;
        
        fun equ (x:t, y:t) = RT_l_3.equ(#1 x, #1 y) andalso 
                             RT_l_3.equ(#2 x, #2 y);
        
        fun toString (x:t) = "(" ^
                             (RT_l_3.toString(#1 x )) ^ "," ^
                             (RT_l_3.toString(#2 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_l_3.typeToString ()) ^ " >< " ^
                              (RT_l_3.typeToString ()) ^
                              ")";
    end;
    
structure RT_x_8 =
    struct
        type t = RT_Int.t * RT_Int.t * RT_m_2.t * RT_l_3.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_Int.equ(#2 x, #2 y) andalso 
                             RT_m_2.equ(#3 x, #3 y) andalso 
                             RT_l_3.equ(#4 x, #4 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_Int.toString(#2 x )) ^ "," ^
                             (RT_m_2.toString(#3 x )) ^ "," ^
                             (RT_l_3.toString(#4 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_m_2.typeToString ()) ^ " >< " ^
                              (RT_l_3.typeToString ()) ^
                              ")";
    end;
    
structure RT_x_9 =
    struct
        type t = RT_Int.t * RT_s_1.t * RT_Int.t * RT_m_2.t * RT_l_3.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_s_1.equ(#2 x, #2 y) andalso 
                             RT_Int.equ(#3 x, #3 y) andalso 
                             RT_m_2.equ(#4 x, #4 y) andalso 
                             RT_l_3.equ(#5 x, #5 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_s_1.toString(#2 x )) ^ "," ^
                             (RT_Int.toString(#3 x )) ^ "," ^
                             (RT_m_2.toString(#4 x )) ^ "," ^
                             (RT_l_3.toString(#5 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_s_1.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_m_2.typeToString ()) ^ " >< " ^
                              (RT_l_3.typeToString ()) ^
                              ")";
    end;
    
structure RT_x_10 =
    struct
        type t = RT_Int.t * RT_Int.t * RT_s_1.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_Int.equ(#2 x, #2 y) andalso 
                             RT_s_1.equ(#3 x, #3 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_Int.toString(#2 x )) ^ "," ^
                             (RT_s_1.toString(#3 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_s_1.typeToString ()) ^
                              ")";
    end;
    
structure RT_x_11 =
    struct
        type t = RT_Int.t * RT_Int.t * RT_Int.t * RT_Int.t * RT_s_1.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_Int.equ(#2 x, #2 y) andalso 
                             RT_Int.equ(#3 x, #3 y) andalso 
                             RT_Int.equ(#4 x, #4 y) andalso 
                             RT_s_1.equ(#5 x, #5 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_Int.toString(#2 x )) ^ "," ^
                             (RT_Int.toString(#3 x )) ^ "," ^
                             (RT_Int.toString(#4 x )) ^ "," ^
                             (RT_s_1.toString(#5 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_s_1.typeToString ()) ^
                              ")";
    end;
    
structure RT_x_12 =
    struct
        type t = RT_x_4.t * RT_x_4.t;
        
        fun equ (x:t, y:t) = RT_x_4.equ(#1 x, #1 y) andalso 
                             RT_x_4.equ(#2 x, #2 y);
        
        fun toString (x:t) = "(" ^
                             (RT_x_4.toString(#1 x )) ^ "," ^
                             (RT_x_4.toString(#2 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_x_4.typeToString ()) ^ " >< " ^
                              (RT_x_4.typeToString ()) ^
                              ")";
    end;
    
structure RT_x_13 =
    struct
        type t = RT_Int.t * RT_l_3.t;
        
        fun equ (x:t, y:t) = RT_Int.equ(#1 x, #1 y) andalso 
                             RT_l_3.equ(#2 x, #2 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Int.toString(#1 x )) ^ "," ^
                             (RT_l_3.toString(#2 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_l_3.typeToString ()) ^
                              ")";
    end;
    
structure RT_Text = RT_Text;

structure RT_x_14 =
    struct
        type t = RT_l_3.t * RT_m_2.t;
        
        fun equ (x:t, y:t) = RT_l_3.equ(#1 x, #1 y) andalso 
                             RT_m_2.equ(#2 x, #2 y);
        
        fun toString (x:t) = "(" ^
                             (RT_l_3.toString(#1 x )) ^ "," ^
                             (RT_m_2.toString(#2 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_l_3.typeToString ()) ^ " >< " ^
                              (RT_m_2.typeToString ()) ^
                              ")";
    end;
    
structure RT_f_15 = RT_Fun(structure Param = RT_m_2 val arrow = "-~->" structure Result = RT_Bool);

structure RT_x_16 =
    struct
        type t = RT_l_3.t * RT_Int.t * RT_Int.t;
        
        fun equ (x:t, y:t) = RT_l_3.equ(#1 x, #1 y) andalso 
                             RT_Int.equ(#2 x, #2 y) andalso 
                             RT_Int.equ(#3 x, #3 y);
        
        fun toString (x:t) = "(" ^
                             (RT_l_3.toString(#1 x )) ^ "," ^
                             (RT_Int.toString(#2 x )) ^ "," ^
                             (RT_Int.toString(#3 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_l_3.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^ " >< " ^
                              (RT_Int.typeToString ()) ^
                              ")";
    end;
    
structure TG4 =
    struct
        type Graph_ = RT_m_2.t;
        
        type Bounded_queue_ = RT_l_3.t;
        
        type Point_ = RT_Int.t;
        
        type Arc_ = RT_x_4.t;
        
        type Arcs_ = RT_s_5.t;
        
        type Coord_ = RT_x_4.t;
        
        fun point2text'9157_ p'91C6_ = if RT_Int.R_ge (p'91C6_, RT_Int.fromLit "10") then RT_Text.R_concat (((point2text'9157_) (RT_Int.R_div (p'91C6_, RT_Int.fromLit "10"))), ((point2text'9157_) (RT_Int.R_mod (p'91C6_, RT_Int.fromLit "10")))) else if RT_Int.equ (p'91C6_, RT_Int.fromLit "0") then RT_Text.fromLit "0" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "1") then RT_Text.fromLit "1" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "2") then RT_Text.fromLit "2" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "3") then RT_Text.fromLit "3" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "4") then RT_Text.fromLit "4" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "5") then RT_Text.fromLit "5" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "6") then RT_Text.fromLit "6" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "7") then RT_Text.fromLit "7" else if RT_Int.equ (p'91C6_, RT_Int.fromLit "8") then RT_Text.fromLit "8" else RT_Text.fromLit "9";
        
        fun arcs2vcg'985F_ ars'98CC_ = if RT_s_5.equ (ars'98CC_, RT_s_5.R_fromList []) then RT_Text.fromLit "" else let
            val (x'99F8_, y'99FB_) = (RT_s_5.R_choose (fn (x'99F8_, y'99FB_) => true) (ars'98CC_))
        in
            RT_Text.R_concat (RT_Text.R_concat (RT_Text.R_concat (RT_Text.R_concat (RT_Text.R_concat (RT_Text.fromLit "edge: {sourcename: \"", ((point2text'9157_) (x'99F8_))), RT_Text.fromLit "\" targetname: \""), ((point2text'9157_) (y'99FB_))), RT_Text.fromLit "\" arrowstyle: none}\n"), ((arcs2vcg'985F_) (RT_s_5.R_diff (ars'98CC_, RT_s_5.R_fromList ([(x'99F8_, y'99FB_), (y'99FB_, x'99F8_)])))))
        end;
        
        fun points2vcg'8D6F_ ps'8DDE_ = if RT_s_1.equ (ps'8DDE_, RT_s_1.R_fromList []) then RT_Text.fromLit "" else let
            val p'8F07_ = (RT_s_1.R_choose (fn p'8F07_ => true) (ps'8DDE_))
        in
            RT_Text.R_concat (RT_Text.R_concat (RT_Text.R_concat (RT_Text.fromLit "node: {title: \"", ((point2text'9157_) (p'8F07_))), RT_Text.fromLit "\"}\n"), ((points2vcg'8D6F_) (RT_s_1.R_diff (ps'8DDE_, RT_s_1.R_fromList ([p'8F07_])))))
        end;
        
        fun is_graph'5B0B_ m'5B78_ = ((RT_m_2.R_all (fn (x'5BDA_:RT_Int.t) => ((RT_s_1.R_all (fn (y'5CA7_:RT_Int.t) => (RT_m_2.R_mem (y'5CA7_, m'5B78_)) andalso ((RT_s_1.R_mem (x'5BDA_, ((RT_m_2.R_app(m'5B78_)) (y'5CA7_)))) andalso ((RSL.C_not RT_Int.equ) (x'5BDA_, y'5CA7_)))) (((RT_m_2.R_app(m'5B78_)) (x'5BDA_)))))) (m'5B78_)));
        
        fun RSL_is_Graph'55FF_ m'5602_ = ((is_graph'5B0B_) (m'5602_));
        
        val max_steps'5A43_ = ((RT_Int.fromLit "100"):RT_Int.t);
        
        fun arcs'86CB_ g'8734_ = if RT_m_2.equ (g'8734_, RT_m_2.R_fromList []) then RT_s_5.R_fromList [] else let
            val x'8863_ = ((RT_m_2.R_hd(g'8734_)):RT_Int.t)
        in
            RT_s_5.R_union (((arcs'86CB_) (RT_m_2.R_restrBySet (g'8734_, RT_s_1.R_fromList ([x'8863_])))), let
                val s'892D_ = (((RT_s_5.R_compss (fn (y'893B_:RT_Int.t) => (x'8863_, y'893B_)) (fn (y'893B_:RT_Int.t) => true) (((RT_m_2.R_app(g'8734_)) (x'8863_))))):RT_s_5.t)
            in
                s'892D_
            end)
        end;
        
        fun graph2vcg'8B7B_ g'8BE9_ = if not(((RSL_is_Graph'55FF_) (g'8BE9_))) then raise RSL.RSL_exception ("G4.rsl:141:7: Argument of graph2vcg" ^ "(" ^ RT_m_2.toString g'8BE9_ ^ ")" ^ " not in subtype") else RT_Text.R_concat (RT_Text.R_concat (RT_Text.R_concat (RT_Text.fromLit "graph: {\ntitle: \"GRAPH\"\n", ((points2vcg'8D6F_) (RT_m_2.R_dom(g'8BE9_)))), ((arcs2vcg'985F_) (((arcs'86CB_) (g'8BE9_))))), RT_Text.fromLit "}\n");
        
        val max_mem'59DF_ = ((RT_Int.fromLit "100"):RT_Int.t);
        
        fun RSL_is_Bounded_queue'566B_ q'566E_ = RT_Int.R_le (RT_l_3.R_length(q'566E_), max_mem'59DF_);
        
        val steps_: RT_Int.t ref = ref (RT_Int.fromLit "0");
        fun add'8347_ (x'8413_, l'8416_) = if not(((RSL_is_Bounded_queue'566B_) (l'8416_))) then raise RSL.RSL_exception ("G4.rsl:120:7: Argument of add" ^ RT_x_13.toString (x'8413_, l'8416_) ^ " not in subtype") else if not(RT_Int.R_gt (max_mem'59DF_, RT_Int.fromLit "0")) then raise RSL.RSL_exception ("G4.rsl:127:6: Precondition of add" ^ RT_x_13.toString (x'8413_, l'8416_) ^ " not satisfied") else (steps_ := RT_Int.R_add (!steps_, RT_Int.fromLit "1"); if RT_Int.R_lt (RT_l_3.R_length(l'8416_), max_mem'59DF_) then RT_l_3.R_concat (l'8416_, [x'8413_]) else RT_l_3.R_concat (RT_l_3.R_tl(l'8416_), [x'8413_]));
        
        fun dir'7E33_ ((x1'7E9C_, y1'7EA0_), (x2'7EA6_, y2'7EAA_)) = if not((RSL.C_not RT_x_4.equ) ((x1'7E9C_, y1'7EA0_), (x2'7EA6_, y2'7EAA_))) then raise RSL.RSL_exception ("G4.rsl:118:11: Precondition of dir" ^ RT_x_12.toString ((x1'7E9C_, y1'7EA0_), (x2'7EA6_, y2'7EAA_)) ^ " not satisfied") else if RT_Int.R_ge (x2'7EA6_, x1'7E9C_) then RT_Int.R_mod ((RT_Int.R_add (RT_Int.fromLit "360", RT_Int.R_div ((RT_Int.R_mul ((RT_Int.R_sub (y2'7EAA_, y1'7EA0_)), RT_Int.fromLit "90")), (RT_Int.R_add (RT_Int.R_abs((RT_Int.R_sub (y2'7EAA_, y1'7EA0_))), RT_Int.R_abs((RT_Int.R_sub (x2'7EA6_, x1'7E9C_)))))))), RT_Int.fromLit "360") else RT_Int.R_sub (RT_Int.fromLit "180", RT_Int.R_div ((RT_Int.R_mul ((RT_Int.R_sub (y2'7EAA_, y1'7EA0_)), RT_Int.fromLit "90")), (RT_Int.R_add (RT_Int.R_abs((RT_Int.R_sub (y2'7EAA_, y1'7EA0_))), RT_Int.R_abs((RT_Int.R_sub (x2'7EA6_, x1'7E9C_)))))));
        
        fun nearest1'7663_ (x'7734_, bxy'7737_, bxz'773C_, z'7741_, s'7744_) = if not((RSL.C_not RT_s_1.R_mem) (x'7734_, s'7744_)) then raise RSL.RSL_exception ("G4.rsl:102:11: Precondition of nearest1" ^ RT_x_11.toString (x'7734_, bxy'7737_, bxz'773C_, z'7741_, s'7744_) ^ " not satisfied") else if RT_s_1.equ (s'7744_, RT_s_1.R_fromList []) then z'7741_ else let
            val i'78C1_ = ((RT_s_1.R_hd(s'7744_)):RT_Int.t); 
            val bxi'7925_ = ((((dir'7E33_) ((RT_Int.R_div (x'7734_, RT_Int.fromLit "10"), RT_Int.R_mod (x'7734_, RT_Int.fromLit "10")), (RT_Int.R_div (i'78C1_, RT_Int.fromLit "10"), RT_Int.R_mod (i'78C1_, RT_Int.fromLit "10"))))):RT_Int.t)
        in
            if RT_Int.R_lt (RT_Int.R_abs((RT_Int.R_sub (bxi'7925_, bxy'7737_))), RT_Int.R_abs((RT_Int.R_sub (bxz'773C_, bxy'7737_)))) then ((nearest1'7663_) (x'7734_, bxy'7737_, bxi'7925_, i'78C1_, RT_s_1.R_diff (s'7744_, RT_s_1.R_fromList ([i'78C1_])))) else ((nearest1'7663_) (x'7734_, bxy'7737_, bxz'773C_, z'7741_, RT_s_1.R_diff (s'7744_, RT_s_1.R_fromList ([i'78C1_]))))
        end;
        
        fun nearest'727B_ (x'72E7_, y'72EA_, s'72ED_) = if not(((RSL.C_not RT_s_1.equ) (s'72ED_, RT_s_1.R_fromList [])) andalso (((RSL.C_not RT_Int.equ) (x'72E7_, y'72EA_)) andalso ((RSL.C_not RT_s_1.R_mem) (x'72E7_, s'72ED_)))) then raise RSL.RSL_exception ("G4.rsl:85:11: Precondition of nearest" ^ RT_x_10.toString (x'72E7_, y'72EA_, s'72ED_) ^ " not satisfied") else let
            val z'7349_ = ((RT_s_1.R_hd(s'72ED_)):RT_Int.t)
        in
            ((nearest1'7663_) (x'72E7_, ((dir'7E33_) ((RT_Int.R_div (x'72E7_, RT_Int.fromLit "10"), RT_Int.R_mod (x'72E7_, RT_Int.fromLit "10")), (RT_Int.R_div (y'72EA_, RT_Int.fromLit "10"), RT_Int.R_mod (y'72EA_, RT_Int.fromLit "10")))), ((dir'7E33_) ((RT_Int.R_div (x'72E7_, RT_Int.fromLit "10"), RT_Int.R_mod (x'72E7_, RT_Int.fromLit "10")), (RT_Int.R_div (z'7349_, RT_Int.fromLit "10"), RT_Int.R_mod (z'7349_, RT_Int.fromLit "10")))), z'7349_, RT_s_1.R_diff (s'72ED_, RT_s_1.R_fromList ([z'7349_]))))
        end;
        
        fun some_path'697F_ (x'6AB5_, next'6AB8_, y'6ABE_, g'6AC1_, pl'6AC4_) = if not((((RSL_is_Graph'55FF_) (g'6AC1_))) andalso (((RSL_is_Bounded_queue'566B_) (pl'6AC4_)))) then raise RSL.RSL_exception ("G4.rsl:54:7: Argument of some_path" ^ RT_x_9.toString (x'6AB5_, next'6AB8_, y'6ABE_, g'6AC1_, pl'6AC4_) ^ " not in subtype") else if not((RT_s_1.R_subs (next'6AB8_, RT_m_2.R_dom(g'6AC1_))) andalso ((RT_s_1.equ (RT_s_1.R_inter (next'6AB8_, RT_l_3.R_elems(pl'6AC4_)), RT_s_1.R_fromList [])) andalso (((RSL.C_not RT_Int.equ) (x'6AB5_, y'6ABE_)) andalso ((RSL.C_not RT_s_1.R_mem) (x'6AB5_, next'6AB8_))))) then raise RSL.RSL_exception ("G4.rsl:74:9: Precondition of some_path" ^ RT_x_9.toString (x'6AB5_, next'6AB8_, y'6ABE_, g'6AC1_, pl'6AC4_) ^ " not satisfied") else if RT_s_1.equ (next'6AB8_, RT_s_1.R_fromList []) then (([]:RT_l_3.t), pl'6AC4_) else if RT_Int.R_ge (!steps_, max_steps'5A43_) then ([RT_Int.R_neg(RT_Int.fromLit "1")], pl'6AC4_) else let
            val z'6CA5_ = ((((nearest'727B_) (x'6AB5_, y'6ABE_, next'6AB8_))):RT_Int.t); 
            val (l'6D0A_, pl1'6D0D_) = ((((a_path1'60E7_) (z'6CA5_, y'6ABE_, g'6AC1_, pl'6AC4_))):RT_x_7.t)
        in
            if RT_l_3.equ (l'6D0A_, ([]:RT_l_3.t)) then ((some_path'697F_) (x'6AB5_, RT_s_1.R_diff (next'6AB8_, (RT_s_1.R_union (RT_s_1.R_fromList ([z'6CA5_]), RT_l_3.R_elems(pl1'6D0D_)))), y'6ABE_, g'6AC1_, pl1'6D0D_)) else (l'6D0A_, pl1'6D0D_)
        end
        and a_path1'60E7_ (x'621B_, y'621E_, g'6221_, pl'6224_) = if not((((RSL_is_Graph'55FF_) (g'6221_))) andalso (((RSL_is_Bounded_queue'566B_) (pl'6224_)))) then raise RSL.RSL_exception ("G4.rsl:32:7: Argument of a_path1" ^ RT_x_8.toString (x'621B_, y'621E_, g'6221_, pl'6224_) ^ " not in subtype") else if not((RT_m_2.R_mem (x'621B_, g'6221_)) andalso ((RSL.C_not RT_l_3.R_mem) (x'621B_, pl'6224_))) then raise RSL.RSL_exception ("G4.rsl:52:11: Precondition of a_path1" ^ RT_x_8.toString (x'621B_, y'621E_, g'6221_, pl'6224_) ^ " not satisfied") else if RT_Int.equ (x'621B_, y'621E_) then ([x'621B_], pl'6224_) else let
            val next'6347_ = ((RT_s_1.R_diff (((RT_m_2.R_app(g'6221_)) (x'621B_)), RT_l_3.R_elems(pl'6224_))):RT_s_1.t)
        in
            if RT_s_1.R_mem (y'621E_, next'6347_) then ([x'621B_, y'621E_], ((add'8347_) (x'621B_, pl'6224_))) else let
                val (l'64DA_, pl1'64DD_) = ((((some_path'697F_) (x'621B_, next'6347_, y'621E_, g'6221_, ((add'8347_) (x'621B_, pl'6224_))))):RT_x_7.t)
            in
                if RT_l_3.equ (l'64DA_, ([]:RT_l_3.t)) then (([]:RT_l_3.t), pl1'64DD_) else (RT_l_3.R_concat ([x'621B_], l'64DA_), pl1'64DD_)
            end
        end;
        
        fun a_path'5E2B_ (x'5EFA_, y'5EFD_, g'5F00_) = if not(((RSL_is_Graph'55FF_) (g'5F00_))) then raise RSL.RSL_exception ("G4.rsl:25:7: Argument of a_path" ^ RT_x_6.toString (x'5EFA_, y'5EFD_, g'5F00_) ^ " not in subtype") else if not(RT_m_2.R_mem (x'5EFA_, g'5F00_)) then raise RSL.RSL_exception ("G4.rsl:30:11: Precondition of a_path" ^ RT_x_6.toString (x'5EFA_, y'5EFD_, g'5F00_) ^ " not satisfied") else (steps_ := RT_Int.fromLit "0"; let
            val (l'5FC2_, pl'5FC5_) = ((((a_path1'60E7_) (x'5EFA_, y'5EFD_, g'5F00_, ([]:RT_l_3.t)))):RT_x_7.t)
        in
            l'5FC2_
        end);
        
        fun add_path'2C3_ (pl'330_, g'334_) = if not(((RSL_is_Graph'55FF_) (g'334_))) then raise RSL.RSL_exception ("TG4.rsl:7:7: Argument of add_path" ^ RT_x_14.toString (pl'330_, g'334_) ^ " not in subtype") else (case ((pl'330_):RT_l_3.t) of [] => g'334_ | [_] => g'334_ | p1'4BD_::p2'4C1_::t'4C8_ => if RT_Int.equ (p1'4BD_, p2'4C1_) then ((add_path'2C3_) (RT_l_3.R_tl(pl'330_), g'334_)) else let
            val g1'651_ = ((if RT_m_2.R_mem (p1'4BD_, g'334_) then g'334_ else RT_m_2.R_override (g'334_, RT_m_2.R_fromList ([(p1'4BD_, RT_s_1.R_fromList [])]))):RT_m_2.t); 
            val g2'7E1_ = ((if RT_m_2.R_mem (p2'4C1_, g1'651_) then g1'651_ else RT_m_2.R_override (g1'651_, RT_m_2.R_fromList ([(p2'4C1_, RT_s_1.R_fromList [])]))):RT_m_2.t); 
            val g3'971_ = ((RT_m_2.R_override (g2'7E1_, RT_m_2.R_fromList ([(p1'4BD_, RT_s_1.R_union (((RT_m_2.R_app(g2'7E1_)) (p1'4BD_)), RT_s_1.R_fromList ([p2'4C1_]))), (p2'4C1_, RT_s_1.R_union (((RT_m_2.R_app(g2'7E1_)) (p2'4C1_)), RT_s_1.R_fromList ([p1'4BD_])))]))):RT_m_2.t)
        in
            ((add_path'2C3_) (RT_l_3.R_tl(pl'330_), g3'971_))
        end);
        
        val grid3'3333_ = ((((add_path'2C3_) ([RT_Int.fromLit "0", RT_Int.fromLit "1", RT_Int.fromLit "2", RT_Int.fromLit "3", RT_Int.fromLit "4", RT_Int.fromLit "5", RT_Int.fromLit "6", RT_Int.fromLit "7", RT_Int.fromLit "8", RT_Int.fromLit "9"], ((add_path'2C3_) ([RT_Int.fromLit "8", RT_Int.fromLit "18", RT_Int.fromLit "28", RT_Int.fromLit "38", RT_Int.fromLit "48", RT_Int.fromLit "58", RT_Int.fromLit "68", RT_Int.fromLit "78", RT_Int.fromLit "88", RT_Int.fromLit "98"], ((add_path'2C3_) ([RT_Int.fromLit "9", RT_Int.fromLit "19", RT_Int.fromLit "29", RT_Int.fromLit "39", RT_Int.fromLit "49", RT_Int.fromLit "59", RT_Int.fromLit "69", RT_Int.fromLit "79", RT_Int.fromLit "89", RT_Int.fromLit "99"], RT_m_2.R_fromList []))))))):RT_m_2.t);
        
        val grid4'3653_ = ((((add_path'2C3_) ([RT_Int.fromLit "8", RT_Int.fromLit "18", RT_Int.fromLit "28", RT_Int.fromLit "38", RT_Int.fromLit "48", RT_Int.fromLit "58", RT_Int.fromLit "68", RT_Int.fromLit "78", RT_Int.fromLit "88", RT_Int.fromLit "98"], ((add_path'2C3_) ([RT_Int.fromLit "7", RT_Int.fromLit "17", RT_Int.fromLit "27", RT_Int.fromLit "37", RT_Int.fromLit "47", RT_Int.fromLit "57", RT_Int.fromLit "67", RT_Int.fromLit "77", RT_Int.fromLit "87", RT_Int.fromLit "97"], ((add_path'2C3_) ([RT_Int.fromLit "6", RT_Int.fromLit "16", RT_Int.fromLit "26", RT_Int.fromLit "36", RT_Int.fromLit "46", RT_Int.fromLit "56", RT_Int.fromLit "66", RT_Int.fromLit "76", RT_Int.fromLit "86", RT_Int.fromLit "96"], ((add_path'2C3_) ([RT_Int.fromLit "96", RT_Int.fromLit "97", RT_Int.fromLit "98"], ((add_path'2C3_) ([RT_Int.fromLit "86", RT_Int.fromLit "87", RT_Int.fromLit "88"], ((add_path'2C3_) ([RT_Int.fromLit "76", RT_Int.fromLit "77", RT_Int.fromLit "78"], ((add_path'2C3_) ([RT_Int.fromLit "66", RT_Int.fromLit "67", RT_Int.fromLit "68"], ((add_path'2C3_) ([RT_Int.fromLit "56", RT_Int.fromLit "57", RT_Int.fromLit "58"], ((add_path'2C3_) ([RT_Int.fromLit "46", RT_Int.fromLit "47", RT_Int.fromLit "48"], grid3'3333_))))))))))))))))))):RT_m_2.t);
        
        fun run4'4337_ (x'4468_, y'446B_) = if RT_m_2.R_mem (x'4468_, grid4'3653_) then let
            val p'4597_ = ((((a_path'5E2B_) (x'4468_, y'446B_, grid4'3653_))):RT_l_3.t)
        in
            (p'4597_, RT_Int.R_sub (RT_l_3.R_length(p'4597_), RT_Int.fromLit "1"), !steps_)
        end else (([]:RT_l_3.t), RT_Int.R_neg(RT_Int.fromLit "1"), RT_Int.fromLit "0");
        
        fun del_path'D4F_ (pl'DBC_, g'DC0_) = if not(((RSL_is_Graph'55FF_) (g'DC0_))) then raise RSL.RSL_exception ("TG4.rsl:34:7: Argument of del_path" ^ RT_x_14.toString (pl'DBC_, g'DC0_) ^ " not in subtype") else (case ((pl'DBC_):RT_l_3.t) of [] => g'DC0_ | [_] => g'DC0_ | p1'F49_::p2'F4D_::t'F54_ => let
            val g1'1013_ = ((if RT_m_2.R_mem (p1'F49_, g'DC0_) then RT_m_2.R_override (g'DC0_, RT_m_2.R_fromList ([(p1'F49_, RT_s_1.R_diff (((RT_m_2.R_app(g'DC0_)) (p1'F49_)), RT_s_1.R_fromList ([p2'F4D_])))])) else g'DC0_):RT_m_2.t); 
            val g2'11A3_ = ((if RT_m_2.R_mem (p2'F4D_, g1'1013_) then RT_m_2.R_override (g1'1013_, RT_m_2.R_fromList ([(p2'F4D_, RT_s_1.R_diff (((RT_m_2.R_app(g1'1013_)) (p2'F4D_)), RT_s_1.R_fromList ([p1'F49_])))])) else g1'1013_):RT_m_2.t)
        in
            ((del_path'D4F_) (RT_l_3.R_tl(pl'DBC_), g2'11A3_))
        end);
        
        fun run3'3E87_ (x'3FB8_, y'3FBB_) = if RT_m_2.R_mem (x'3FB8_, grid3'3333_) then let
            val p'40E7_ = ((((a_path'5E2B_) (x'3FB8_, y'3FBB_, grid3'3333_))):RT_l_3.t)
        in
            (p'40E7_, RT_Int.R_sub (RT_l_3.R_length(p'40E7_), RT_Int.fromLit "1"), !steps_)
        end else (([]:RT_l_3.t), RT_Int.R_neg(RT_Int.fromLit "1"), RT_Int.fromLit "0");
        
        fun adjacent'1583_ n'15F0_ = if not(RT_Int.R_ge (n'15F0_, RT_Int.fromLit "0")) then raise RSL.RSL_exception ("TG4.rsl:55:7: Argument of adjacent" ^ "(" ^ RT_Int.toString n'15F0_ ^ ")" ^ " not in subtype") else RT_s_1.R_union (RT_s_1.R_union (RT_s_1.R_union (if (RSL.C_not RT_Int.equ) (RT_Int.R_mod (n'15F0_, RT_Int.fromLit "10"), RT_Int.fromLit "9") then RT_s_1.R_fromList ([RT_Int.R_add (n'15F0_, RT_Int.fromLit "1")]) else RT_s_1.R_fromList [], if (RSL.C_not RT_Int.equ) (RT_Int.R_mod (n'15F0_, RT_Int.fromLit "10"), RT_Int.fromLit "0") then RT_s_1.R_fromList ([RT_Int.R_sub (n'15F0_, RT_Int.fromLit "1")]) else RT_s_1.R_fromList []), if RT_Int.R_lt (n'15F0_, RT_Int.fromLit "90") then RT_s_1.R_fromList ([RT_Int.R_add (n'15F0_, RT_Int.fromLit "10")]) else RT_s_1.R_fromList []), if RT_Int.R_gt (n'15F0_, RT_Int.fromLit "9") then RT_s_1.R_fromList ([RT_Int.R_sub (n'15F0_, RT_Int.fromLit "10")]) else RT_s_1.R_fromList []);
        
        val grid'183F_ = let val z__'184C_ = (((RT_m_2.R_complm (fn (n'18B9_:RT_Int.t) => (n'18B9_, ((adjacent'1583_) (n'18B9_)))) (fn (n'18B9_:RT_Int.t) => RT_Int.R_ge (n'18B9_, RT_Int.fromLit "0")) (R'a_List.uptoInt(RT_Int.fromLit "0", RT_Int.fromLit "99")))):RT_m_2.t) in if not(((RSL_is_Graph'55FF_) (z__'184C_))) then (RSL.add_load_err("TG4.rsl:62:20: Value " ^ RT_m_2.toString(z__'184C_) ^ " of grid not in subtype"); z__'184C_) else z__'184C_ end;
        
        val grid1'1E1B_ = ((((del_path'D4F_) ([RT_Int.fromLit "20", RT_Int.fromLit "30"], ((del_path'D4F_) ([RT_Int.fromLit "22", RT_Int.fromLit "32"], ((del_path'D4F_) ([RT_Int.fromLit "23", RT_Int.fromLit "33"], ((del_path'D4F_) ([RT_Int.fromLit "24", RT_Int.fromLit "34"], ((del_path'D4F_) ([RT_Int.fromLit "25", RT_Int.fromLit "35"], ((del_path'D4F_) ([RT_Int.fromLit "26", RT_Int.fromLit "36"], ((del_path'D4F_) ([RT_Int.fromLit "27", RT_Int.fromLit "37"], ((del_path'D4F_) ([RT_Int.fromLit "29", RT_Int.fromLit "39"], grid'183F_))))))))))))))))):RT_m_2.t);
        
        val grid2'24BF_ = ((((del_path'D4F_) ([RT_Int.fromLit "48", RT_Int.fromLit "49"], ((del_path'D4F_) ([RT_Int.fromLit "58", RT_Int.fromLit "59"], ((del_path'D4F_) ([RT_Int.fromLit "68", RT_Int.fromLit "69"], ((del_path'D4F_) ([RT_Int.fromLit "78", RT_Int.fromLit "79"], ((del_path'D4F_) ([RT_Int.fromLit "88", RT_Int.fromLit "89"], ((del_path'D4F_) ([RT_Int.fromLit "98", RT_Int.fromLit "99"], grid1'1E1B_))))))))))))):RT_m_2.t);
        
        fun run2'2E83_ (x'2FB4_, y'2FB7_) = if RT_m_2.R_mem (x'2FB4_, grid2'24BF_) then let
            val p'30E3_ = ((((a_path'5E2B_) (x'2FB4_, y'2FB7_, grid2'24BF_))):RT_l_3.t)
        in
            (p'30E3_, RT_Int.R_sub (RT_l_3.R_length(p'30E3_), RT_Int.fromLit "1"), !steps_)
        end else (([]:RT_l_3.t), RT_Int.R_neg(RT_Int.fromLit "1"), RT_Int.fromLit "0");
        
        fun run'196B_ (x'1A9B_, y'1A9E_) = if RT_m_2.R_mem (x'1A9B_, grid'183F_) then let
            val p'1BCB_ = ((((a_path'5E2B_) (x'1A9B_, y'1A9E_, grid'183F_))):RT_l_3.t)
        in
            (p'1BCB_, RT_Int.R_sub (RT_l_3.R_length(p'1BCB_), RT_Int.fromLit "1"), !steps_)
        end else (([]:RT_l_3.t), RT_Int.R_neg(RT_Int.fromLit "1"), RT_Int.fromLit "0");
        
        fun run1'29D3_ (x'2B04_, y'2B07_) = if RT_m_2.R_mem (x'2B04_, grid1'1E1B_) then let
            val p'2C33_ = ((((a_path'5E2B_) (x'2B04_, y'2B07_, grid1'1E1B_))):RT_l_3.t)
        in
            (p'2C33_, RT_Int.R_sub (RT_l_3.R_length(p'2C33_), RT_Int.fromLit "1"), !steps_)
        end else (([]:RT_l_3.t), RT_Int.R_neg(RT_Int.fromLit "1"), RT_Int.fromLit "0");
        
    end;
    
open TG4;

RSL.print_load_errs();
(RSL.C_output "[t1_12] " RT_x_16.toStringSafe (fn _ => ((run'196B_) (RT_Int.fromLit "1", RT_Int.fromLit "12"))));

(RSL.C_output "[t1_29] " RT_x_16.toStringSafe (fn _ => ((run'196B_) (RT_Int.fromLit "1", RT_Int.fromLit "29"))));

(RSL.C_output "[t1_39] " RT_x_16.toStringSafe (fn _ => ((run'196B_) (RT_Int.fromLit "1", RT_Int.fromLit "39"))));

(RSL.C_output "[t1_49] " RT_x_16.toStringSafe (fn _ => ((run'196B_) (RT_Int.fromLit "1", RT_Int.fromLit "49"))));

(RSL.C_output "[t0_99] " RT_x_16.toStringSafe (fn _ => ((run'196B_) (RT_Int.fromLit "0", RT_Int.fromLit "99"))));

(RSL.C_output "[t99_0] " RT_x_16.toStringSafe (fn _ => ((run'196B_) (RT_Int.fromLit "99", RT_Int.fromLit "0"))));

(RSL.C_output "[t1_0_99] " RT_x_16.toStringSafe (fn _ => ((run1'29D3_) (RT_Int.fromLit "0", RT_Int.fromLit "99"))));

(RSL.C_output "[t1_99_0] " RT_x_16.toStringSafe (fn _ => ((run1'29D3_) (RT_Int.fromLit "99", RT_Int.fromLit "0"))));

(RSL.C_output "[t2_0_99] " RT_x_16.toStringSafe (fn _ => ((run2'2E83_) (RT_Int.fromLit "0", RT_Int.fromLit "99"))));

(RSL.C_output "[t2_99_0] " RT_x_16.toStringSafe (fn _ => ((run2'2E83_) (RT_Int.fromLit "99", RT_Int.fromLit "0"))));

(RSL.C_output "[t3_99_0] " RT_x_16.toStringSafe (fn _ => ((run3'3E87_) (RT_Int.fromLit "99", RT_Int.fromLit "0"))));

(RSL.C_output "[t3_0_99] " RT_x_16.toStringSafe (fn _ => ((run3'3E87_) (RT_Int.fromLit "0", RT_Int.fromLit "99"))));

(RSL.C_output "[t4_99_0] " RT_x_16.toStringSafe (fn _ => ((run4'4337_) (RT_Int.fromLit "99", RT_Int.fromLit "0"))));

(RSL.C_output "[t4_0_99] " RT_x_16.toStringSafe (fn _ => ((run4'4337_) (RT_Int.fromLit "0", RT_Int.fromLit "99"))));

(RSL.C_output "[no_path] " RT_x_16.toStringSafe (fn _ => ((run2'2E83_) (RT_Int.fromLit "0", RT_Int.fromLit "100"))));

RSL.print_error_count();
