Compiler.Control.Print.signatures := 0;
Compiler.Control.Print.printOpens := false;
SMLofNJ.Internals.GC.messages false;
CM.autoloading (SOME true);
CM.autoload' "/home/cwg/sml/rslml/rslml.cm";

structure RT_Bool = RT_Bool;

structure RT_Nat = RT_Nat;

structure RT_Text = RT_Text;

structure RT_x_3 =
    struct
        type t = RT_Nat.t * RT_Text.t * RT_Nat.t;
        
        fun equ (x:t, y:t) = RT_Nat.equ(#1 x, #1 y) andalso 
                             RT_Text.equ(#2 x, #2 y) andalso 
                             RT_Nat.equ(#3 x, #3 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Nat.toString(#1 x )) ^ "," ^
                             (RT_Text.toString(#2 x )) ^ "," ^
                             (RT_Nat.toString(#3 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Nat.typeToString ()) ^ " >< " ^
                              (RT_Text.typeToString ()) ^ " >< " ^
                              (RT_Nat.typeToString ()) ^
                              ")";
    end;
    
structure RT_s_4 = RT_Set(structure Elem = RT_Nat);

structure RT_u_Transaction__1 =
    struct
        datatype t = mk_Transaction_ of RT_x_3.t;
        
        fun date_ (mk_Transaction_ x) = let val (i,_,_) = x in i end;
        fun description_ (mk_Transaction_ x) = let val (_,i,_) = x in i end;
        fun balance_ (mk_Transaction_ x) = let val (_,_,i) = x in i end;
        
        fun equ (mk_Transaction_ x, mk_Transaction_ y) = RT_x_3.equ (x, y);
        
        fun toString (mk_Transaction_ x) = "mk_Transaction" ^ (RT_x_3.toString (x));
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "Transaction";
    end;
    
structure RT_l_2 = RT_List(structure Elem = RT_u_Transaction__1);

structure RT_x_5 =
    struct
        type t = RT_Nat.t * RT_Text.t * RT_Nat.t * RT_l_2.t;
        
        fun equ (x:t, y:t) = RT_Nat.equ(#1 x, #1 y) andalso 
                             RT_Text.equ(#2 x, #2 y) andalso 
                             RT_Nat.equ(#3 x, #3 y) andalso 
                             RT_l_2.equ(#4 x, #4 y);
        
        fun toString (x:t) = "(" ^
                             (RT_Nat.toString(#1 x )) ^ "," ^
                             (RT_Text.toString(#2 x )) ^ "," ^
                             (RT_Nat.toString(#3 x )) ^ "," ^
                             (RT_l_2.toString(#4 x )) ^
                             ")";
        
        fun toStringSafe x = toString(x())
          handle RSL.RSL_exception s => (RSL.inc_exception_count(); s);
        
        fun typeToString () = "(" ^
                              (RT_Nat.typeToString ()) ^ " >< " ^
                              (RT_Text.typeToString ()) ^ " >< " ^
                              (RT_Nat.typeToString ()) ^ " >< " ^
                              (RT_l_2.typeToString ()) ^
                              ")";
    end;
    
structure TACC1 =
    struct
        type Account_ = RT_l_2.t;
        
        type Transaction_ = RT_u_Transaction__1.t;
        
        type Description_ = RT_Text.t;
        
        type Date_ = RT_Nat.t;
        
        type Amount_ = RT_Nat.t;
        
        val zero'F3D_ = ((RT_Int.fromLit "0"):RT_Nat.t);
        
        fun is_date_ordered'A8D_ l'B01_ = ((RT_s_4.R_all (fn (i'BBE_:RT_Nat.t) => not (RT_Nat.R_ge (i'BBE_, RT_Int.fromLit "0")) orelse (((RT_s_4.R_all (fn (j'C24_:RT_Nat.t) => not (RT_Nat.R_ge (j'C24_, RT_Int.fromLit "0")) orelse (not (RT_Nat.R_lt (i'BBE_, j'C24_)) orelse (RT_Nat.R_le (((RT_u_Transaction__1.date_) (((RT_l_2.R_app(l'B01_)) (j'C24_)))), ((RT_u_Transaction__1.date_) (((RT_l_2.R_app(l'B01_)) (i'BBE_)))))))) (RT_l_2.R_inds((l'B01_))))))) (RT_l_2.R_inds((l'B01_)))));
        
        fun RSL_is_Account'71A_ l'71D_ = ((is_date_ordered'A8D_) (l'71D_));
        
        fun balance'1005_ ac'1071_ = if not(((RSL_is_Account'71A_) (ac'1071_))) then raise RSL.RSL_exception ("ACC1.rsl:27:1: Argument of balance" ^ "(" ^ RT_l_2.toString ac'1071_ ^ ")" ^ " not in subtype") else (case ((ac'1071_):RT_l_2.t) of [] => zero'F3D_ | t'119B_::ac1'119F_ => ((RT_u_Transaction__1.balance_) (t'119B_)));
        
        fun in_the_red'14B5_ ac'1524_ = if not(((RSL_is_Account'71A_) (ac'1524_))) then raise RSL.RSL_exception ("ACC1.rsl:39:1: Argument of in_the_red" ^ "(" ^ RT_l_2.toString ac'1524_ ^ ")" ^ " not in subtype") else RT_Nat.R_lt (((balance'1005_) (ac'1524_)), RT_Int.fromLit "0");
        
        fun add'12C1_ (d'1329_, desc'132C_, a'1332_, ac'1335_) = if not((RT_Nat.R_ge (d'1329_, RT_Int.fromLit "0")) andalso (((RSL_is_Account'71A_) (ac'1335_)))) then raise RSL.RSL_exception ("ACC1.rsl:34:1: Argument of add" ^ RT_x_5.toString (d'1329_, desc'132C_, a'1332_, ac'1335_) ^ " not in subtype") else if not((RT_l_2.equ (ac'1335_, ([]:RT_l_2.t))) orelse (RT_Nat.R_le (((RT_u_Transaction__1.date_) (RT_l_2.R_hd((ac'1335_)))), d'1329_))) then raise RSL.RSL_exception ("ACC1.rsl:37:5: Precondition of add" ^ RT_x_5.toString (d'1329_, desc'132C_, a'1332_, ac'1335_) ^ " not satisfied") else RT_l_2.R_concat ([((RT_u_Transaction__1.mk_Transaction_) (d'1329_, desc'132C_, RT_Nat.R_add (((balance'1005_) (ac'1335_)), a'1332_)))], ac'1335_);
        
        val ac'1F5_ = ((((add'12C1_) (RT_Int.fromLit "3", RT_Text.fromLit "payment", RT_Int.fromLit "45", ((add'12C1_) (RT_Int.fromLit "2", RT_Text.fromLit "demand", RT_Nat.R_neg(RT_Int.fromLit "53"), ([]:RT_l_2.t)))))):RT_l_2.t);
        
    end;
    
open TACC1;

RSL.print_load_errs();
(RSL.C_output "[t1] " RT_l_2.toStringSafe (fn _ => ac'1F5_));

(RSL.C_output "[t2] " RT_l_2.toStringSafe (fn _ => ((add'12C1_) (RT_Int.fromLit "2", RT_Text.fromLit "payment", RT_Int.fromLit "8", ac'1F5_))));

(RSL.C_output "[t3] " RT_Bool.toStringSafe (fn _ => RT_Nat.equ (((balance'1005_) (ac'1F5_)), RT_Nat.R_neg(RT_Int.fromLit "8"))));

(RSL.C_output "[t4] " RT_Bool.toStringSafe (fn _ => RT_Bool.equ (((in_the_red'14B5_) (ac'1F5_)), true)));

RSL.print_error_count();
